// Service worker for Yopicky Chrome Extension
// Automatically opens the side panel when extension icon is clicked

chrome.sidePanel
  .setPanelBehavior({ openPanelOnActionClick: true })
  .catch((error) => console.error('Error setting panel behavior:', error));

// Listen for extension icon click
chrome.action.onClicked.addListener((tab) => {
  // Open side panel for the current window
  chrome.sidePanel.open({ windowId: tab.windowId });
});

// Optional: Listen for when the side panel is opened
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === 'GET_TAB_INFO') {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      if (tabs[0]) {
        sendResponse({ url: tabs[0].url, tabId: tabs[0].id });
      }
    });
    return true;
  }
});
