 
chrome.tabs.query({active: true, lastFocusedWindow: true}, tabs => {
    //console.log(tabs)
    
});

window.onload = onWindowLoad;
function onWindowLoad() {
    // Initialize UI first
    document.querySelector(".loader").style.display = "none";
    initializePopup();
    
    // Restore car info collapsed state
    setTimeout(() => {
        const isCollapsed = localStorage.getItem('yopicky_car_info_collapsed') === 'true';
        if (isCollapsed) {
            const header = document.getElementById('carInfoHeader');
            const btn = document.getElementById('carInfoToggleBtn');
            if (header && btn) {
                header.style.maxHeight = '0px';
                header.style.opacity = '0';
                header.style.overflow = 'hidden';
                btn.innerHTML = '<i class="fas fa-chevron-down"></i> Expand';
            }
        }
    }, 200);
}

function initializePopup() {
    const user = getCurrentUser();
    
    // Always update auth UI to show/hide settings button
    if (typeof updateAuthUI === 'function') {
        updateAuthUI();
    }
    
    if (!user) {
        showView('auth');
        return;
    }
    
    // Check if we're on a supported auction site
    chrome.tabs.query({ active: true, currentWindow: true }).then(function(tabs) {
        if (!tabs[0]) return;
        
        const url = tabs[0].url;
        const isSupported = isSupportedAuctionUrl(url);
        
        console.log('📍 Current URL:', url);
        console.log('✅ Is supported site:', isSupported);
        
        if (isSupported) {
            // User is logged in and on supported site, extract data
            onloadEvent(0);
            // Monitor for listing changes while popup is open
            startListingChangeMonitor();
        } else {
            // Not on a supported site, show message
            document.querySelector(".loader").style.display = "none";
            $("#resultdata").html('<div class="category-inner-fix">' +
                '<div class="category-box design-1">' +
                '<h4 class="car-name error">Please go to IAAI.com, Copart.com, SCA Auction, eRepairables, or AutoBidMaster car detail page to search for parts.</h4>' +
                '</div></div>');
        }
    });
}

// Check if URL is a supported auction site listing page
function isSupportedAuctionUrl(url) {
    if (!url) return false;
    
    const supportedPatterns = [
        /copart\.com\/lot\//i,
        /iaai\.com\/(VehicleDetail|vehicle|Vehicle)/i,
        /scaauction\.com/i,
        /sca\.auction/i,
        /erepairables\.com\//i,
        /autobidmaster\.com\//i
    ];
    
    return supportedPatterns.some(pattern => pattern.test(url));
}

// Monitor for listing changes when user navigates to different cars
let lastListingId = null;
let lastTabUrl = null;
let listingMonitorInterval = null;
let currentActiveTabId = null;

function startListingChangeMonitor() {
    // Clear any existing monitor
    if (listingMonitorInterval) {
        clearInterval(listingMonitorInterval);
    }
    
    // Check every 500ms if the listing or URL has changed (faster detection for SPAs)
    listingMonitorInterval = setInterval(() => {
        chrome.tabs.query({ active: true, currentWindow: true }).then(function (tabs) {
            if (!tabs[0]) return;
            
            const currentUrl = tabs[0].url;
            
            // First check: URL changed (works for all navigation types including SPA)
            if (lastTabUrl && lastTabUrl !== currentUrl) {
                console.log('🔗 URL changed detected:', lastTabUrl, '→', currentUrl);
                lastTabUrl = currentUrl;
                lastListingId = null; // Reset listing ID on URL change
                
                // Check if new URL is still a supported auction site
                if (isSupportedAuctionUrl(currentUrl)) {
                    // Clear old results and re-extract
                    document.querySelector(".loader").style.display = "block";
                    $("#resultdata").html('');
                    setTimeout(() => onloadEvent(0), 500); // Small delay for page to load
                } else {
                    // No longer on a supported site
                    document.querySelector(".loader").style.display = "none";
                    $("#resultdata").html('<div class="category-inner-fix">' +
                        '<div class="category-box design-1">' +
                        '<h4 class="car-name error">Please go to a vehicle listing page to search for parts.</h4>' +
                        '</div></div>');
                }
                return;
            }
            
            lastTabUrl = currentUrl;
            
            // Second check: Listing ID changed (works for SPAs that don't change URL)
            chrome.tabs.sendMessage(tabs[0].id, "getListingId", null, function(listingData) {
                if (chrome.runtime.lastError) return; // Ignore errors (tab not ready)
                
                if (listingData && listingData.listingId) {
                    // Check if listing has changed
                    if (lastListingId && lastListingId !== listingData.listingId) {
                        console.log('📍 Listing ID changed detected:', lastListingId, '→', listingData.listingId);
                        lastListingId = listingData.listingId;
                        
                        // Clear old results and re-extract
                        document.querySelector(".loader").style.display = "block";
                        $("#resultdata").html('');
                        onloadEvent(0);
                    } else if (!lastListingId) {
                        // First time detecting listing ID
                        lastListingId = listingData.listingId;
                    }
                }
            });
        });
    }, 500); // Check every 500ms for faster detection
}

function initializeAuthUI() {
    const user = getCurrentUser();
    if (!user) {
        showView('auth');
    } else {
        showView('main');
    }
}

async function onloadEvent(pp){
    var dataP =  parseInt(pp)+1;
    var message = document.querySelector('#message');
    if(dataP>=4){

        document.querySelector(".loader").style.display = "none";
        $("#resultdata").html('<div class="category-inner-fix" >'+
                                '<div class="category-box design-1"  > '+
                                '<h4 class="car-name error">Please go to IAAI.com, Copart.com, SCA Auction, eRepairables, or Autobidmaster car detail page to take full advantage of our Chrome extension.</h4></div></div>');
         
        return false;
    }
    var url_string = document.querySelector("#url_string");
    var car_model = document.querySelector("#car_model"); 
    var car_color = document.querySelector("#car_color");
    var car_damage = document.querySelector("#car_damage");

    chrome.tabs.query({ active: true, currentWindow: true }).then(function (tabs) {
        var activeTab = tabs[0];
        var activeTabId = activeTab.id;
        currentActiveTabId = activeTabId; // Save for use in chained callbacks
 

        let url = tabs[0].url;
        lastTabUrl = url; // Save for change detection

        var body = '';
              
        if(url.includes("copart.com/lot/")) {
            body = "copart";
            url_string.innerText = "https://www.copart.com/";
        }else if(url.includes("iaai.com/VehicleDetail") || url.includes("iaai.com/vehicle") || url.includes("iaai.com/Vehicle")) {
            body = "iaai";
            url_string.innerText = "https://www.iaai.com/";
        }else if(url.includes("scaauction.com") || url.includes("sca.auction")) {
            body = "sca";
            url_string.innerText = url.includes("sca.auction") ? "https://sca.auction/" : "https://scaauction.com/";
        }else if(url.includes("erepairables.com/")) {
            body = "erepairables";
            url_string.innerText = "https://erepairables.com/";
        }else if(url.includes("autobidmaster.com/")) {
            body = "autobidmaster";
            url_string.innerText = "https://www.autobidmaster.com/";
        }
        else{
            message.innerText = 'Invalid page access !!';
            document.querySelector(".loader").style.display = "none";
            $("#resultdata").html('<div class="category-inner-fix" >'+
                                '<div class="category-box design-1"  > '+
                                '<h4 class="car-name error">Please go to IAAI.com, Copart.com, SCA Auction, eRepairables, or Autobidmaster car detail page to take full advantage of our Chrome extension.</h4></div></div>');
            
            initializeAuthUI();
            return Promise.resolve(null);
        }
        return chrome.scripting.executeScript({
            target: { tabId: activeTabId },
            // injectImmediately: true,  // uncomment this to make it execute straight away, other wise it will wait for document_idle
            func: DOMtoString,
            args: [body]  // you can use this to target what element to get the html for
        });

    }).then(function (results) { 
        
        if(!results) {
            return;
        }

        if(results[0].result){

            if( results[0].result.title=="" ||results[0].result.color=="" || results[0].result.damage==""   )
            {   
                message.innerText = "Invalid Page Access"; 
                setTimeout(function(){ onloadEvent(dataP) }, 2000);
            }else{

                if(results[0].result.title){
                    car_model.innerText = results[0].result.title;
                    // Also populate the visible search input field
                    $('#car_search_title').val(results[0].result.title);
                    console.log('📝 Search keyword set to:', results[0].result.title);
                }
                if(results[0].result.color){
                    car_color.innerText = results[0].result.color;
                }
                if(results[0].result.damage){
                    car_damage.innerText = results[0].result.damage;
                }
                if(results[0].result.mileage){
                    document.getElementById('car_mileage').innerText = results[0].result.mileage;
                }

                // Flag to track if search has been triggered
                let searchTriggered = false;
                
                const triggerSearch = () => {
                    if (!searchTriggered) {
                        searchTriggered = true;
                        console.log('🔍 Triggering automatic search...');
                        getDataFirst();
                    }
                };
                
                // Try to get listing ID with timeout
                const listingIdTimeout = setTimeout(() => {
                    console.warn('Listing ID extraction timeout - proceeding with search');
                    triggerSearch();
                }, 500);
                
                chrome.tabs.sendMessage(currentActiveTabId, "getListingId", null, function(listingData) {
                    clearTimeout(listingIdTimeout);
                    
                    if (listingData && listingData.listingId) {
                        window.currentListingData = listingData;
                        lastListingId = listingData.listingId; // Save for change detection
                        console.log('✅ Listing ID extracted:', listingData.listingId);
                    } else {
                        window.currentListingData = { listingId: null, auctionSite: body, country: 'US' };
                    }
                    
                    triggerSearch();
                });

                document.querySelector(".loader").style.display = "none";
            }
        }else{

            setTimeout(function(){ onloadEvent(dataP) }, 2000);
            message.innerText = "Invalid Page Access";   
        }
        //message.innerText = results[0].result;
    }).catch(function (error) {
        console.error('Error in popup initialization:', error);
        document.querySelector(".loader").style.display = "none";
        message.innerText = 'Extension Error';
        initializeAuthUI();
    });



    var yearHtml = '<option value="">Select Year</option>';
    for (var i = 1986; i <= 2025; i++ ){
        yearHtml = yearHtml +'<option value="'+i+'">'+i+'</option>';
    }
    $("#car_year").val();
    $("#car_year").html(yearHtml); 
}
// Function to check subscription status and show/hide ads
async function checkSubscriptionAndShowAds() {
    const adTopContainer = document.getElementById('ad-container-top');
    const adBottomContainer = document.getElementById('ad-container-bottom');
    const mainView = document.getElementById('main-view');
    
    // Helper function to safely show/hide ads
    function setAdsVisibility(show) {
        if (adTopContainer) adTopContainer.style.display = show ? 'block' : 'none';
        if (adBottomContainer) adBottomContainer.style.display = show ? 'block' : 'none';
        if (mainView) mainView.style.paddingBottom = show ? '120px' : '0';
    }
    
    try {
        // Only check subscription if user is logged in
        const user = getCurrentUser();
        if (!user) {
            // Show ads by default if no user logged in
            setAdsVisibility(true);
            return;
        }
        
        const subscription = await api.getSubscriptionStatus();
        
        // Show ads only for free users (not Power Buyer)
        const isFreeUser = subscription.plan !== 'pro_monthly';
        setAdsVisibility(isFreeUser);
    } catch (error) {
        // Silently show ads on any error - don't log warnings that confuse users
        setAdsVisibility(true);
    }
}

$(document).ready(function(){
    $("#submit").on("click",function(){
        getData(1)
    });
    
    // Auto-trigger search when input changes (on blur/change)
    $("#car_search_title").on("change", function(){
        const value = $(this).val();
        if (value && value.trim() !== '') {
            $("#submit").trigger("click");
        }
    });
    
    // Filter toggle functionality
    $("#filterToggleBtn").on("click", function(){
        const filtersContainer = $("#filtersContainer");
        filtersContainer.toggleClass("collapsed");
        const icon = $(this).find("i");
        icon.toggleClass("fa-chevron-up fa-chevron-down");
    });
    
    // Initial ad check on page load - silently handle any errors
    checkSubscriptionAndShowAds().catch(() => {});
})

var BASEURL = 'https://ee1c092d-3167-4f59-b56c-638708490601-00-32pbmujpx1fit.janeway.replit.dev/php/';
//var BASEURL = 'http://localhost/ebay-sdk/';
function getDataFirst(){ 

    $('#car_search_color').val($("#car_color").html());
    $('#car_search_damage').val($("#car_damage").html());
    $('#car_search_title').val($("#car_model").html()); 

    var text = $("#car_model").html();
    const myArray = text.split(" ");
    if(myArray[0]){
        $("#car_year").val(myArray[0].toLowerCase().replace(" ", "-"));
    }
    if(myArray[1]){
        $("#car_make").val(myArray[1].toLowerCase().replace(" ", "-"));
    }

    $("#car_search_key").val( $('#car_search_title').val() + " " + $('#car_search_damage').val() + " " + $('#car_search_color').val() );
   
    // Load smart suggestions based on damage type
    const damageType = $("#car_damage").html();
    if (damageType) {
        loadDamageSuggestions(damageType);
    }

    //getData(1)
    getData()
}

// Load and display smart suggestions based on damage type
async function loadDamageSuggestions(damageDescription) {
    try {
        const result = await api.getPartSuggestions(damageDescription);
        
        if (result.status === 'success' && result.suggestions) {
            displayDamageSuggestions(result.suggestions);
        }
    } catch (error) {
        console.warn('Failed to load suggestions:', error);
    }
}

// Display suggestions in the UI
function displayDamageSuggestions(suggestions) {
    const container = document.getElementById('suggestionsContainer');
    if (!container) return;

    const suggestionsList = document.getElementById('suggestionsList');
    const suggestionEmoji = document.getElementById('suggestionEmoji');
    const suggestionTitle = document.getElementById('suggestionTitle');
    const suggestionDescription = document.getElementById('suggestionDescription');

    // Set title and emoji
    suggestionEmoji.textContent = suggestions.emoji || '💡';
    suggestionTitle.textContent = suggestions.title || 'Smart Suggestions';
    suggestionDescription.textContent = suggestions.description || '';

    // Build suggestion buttons
    suggestionsList.innerHTML = '';
    suggestions.suggestions.forEach(part => {
        const button = document.createElement('button');
        button.textContent = part;
        button.onclick = () => searchForSuggestedPart(part);
        button.style.cssText = `
            background: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.3);
            padding: 6px 12px;
            border-radius: 20px;
            cursor: pointer;
            font-size: 12px;
            font-weight: 500;
            transition: all 0.2s ease;
        `;
        button.onmouseover = (e) => {
            e.target.style.background = 'rgba(255,255,255,0.3)';
            e.target.style.transform = 'scale(1.05)';
        };
        button.onmouseout = (e) => {
            e.target.style.background = 'rgba(255,255,255,0.2)';
            e.target.style.transform = 'scale(1)';
        };
        suggestionsList.appendChild(button);
    });

    // Show the suggestions container
    container.style.display = 'block';
}

// Search for a suggested part
function searchForSuggestedPart(partName) {
    // Set the search query to the suggested part
    $('#car_search_key').val(partName);
    
    // Auto-scroll to search button and trigger search
    setTimeout(() => {
        getData();
    }, 200);
}

// Manual search triggered by the Search button
function manualSearch() {
    const searchQuery = $('#car_search_title').val();
    
    if (!searchQuery || searchQuery.trim() === '') {
        alert('Please enter a search keyword');
        return;
    }
    
    console.log('🔍 Manual search triggered:', searchQuery);
    
    // Show loader and clear previous results
    document.querySelector(".loader").style.display = "block";
    $("#resultdata").html('');
    
    // Trigger search
    getDataFirst();
}

// Calculate recommendation score based on damage type and part title
window.damageKeywords = {
  'FR': ['bumper', 'bumper cover', 'headlight', 'headlamp', 'fender', 'grille', 'grill', 'hood', 'bonnet', 'front panel', 'radiator support', 'front end'],
  'LF': ['bumper', 'bumper cover', 'headlight', 'headlamp', 'left fender', 'left door', 'mirror', 'grille'],
  'RF': ['bumper', 'bumper cover', 'headlight', 'headlamp', 'right fender', 'right door', 'mirror', 'grille'],
  'RE': ['bumper', 'bumper cover', 'taillight', 'tail light', 'brake light', 'trunk', 'boot', 'rear panel', 'rear fender', 'rear end'],
  'LR': ['bumper', 'bumper cover', 'taillight', 'tail light', 'left rear fender', 'left door', 'quarter panel'],
  'RR': ['bumper', 'bumper cover', 'taillight', 'tail light', 'right rear fender', 'right door', 'quarter panel'],
  'LS': ['door', 'mirror', 'side panel', 'fender', 'running board', 'step board', 'rocker panel', 'quarter panel', 'window', 'glass'],
  'RS': ['door', 'mirror', 'side panel', 'fender', 'running board', 'step board', 'rocker panel', 'quarter panel', 'window', 'glass'],
  'RD': ['roof', 'roof panel', 'sunroof', 'roof rail', 'roof rack', 'roof liner'],
  'EN': ['engine', 'motor', 'cylinder head', 'engine block', 'timing chain', 'pistons', 'valves'],
  'TD': ['transmission', 'torque converter', 'transmission fluid', 'valve body', 'shift solenoid'],
  'SU': ['shock absorber', 'strut', 'spring', 'control arm', 'ball joint', 'sway bar', 'suspension'],
  'AO': ['bumper', 'door', 'window', 'roof', 'frame', 'suspension', 'engine', 'transmission'],
  'HL': ['door', 'hood', 'roof', 'bumper', 'fender', 'panel'],
  'WA': ['water', 'flood', 'interior', 'carpet', 'upholstery', 'electrical', 'engine', 'transmission'],
  'FM': ['frame', 'frame damage', 'frame rail', 'chassis', 'body', 'structural'],
  'ST': ['roof', 'frame', 'structural', 'suspension', 'door', 'window', 'all parts'],
  'VA': ['window', 'door', 'mirror', 'bumper', 'light', 'trim'],
  'MC': ['engine', 'motor', 'transmission', 'gearbox', 'alternator', 'starter', 'suspension', 'axle'],
  'BN': ['bumper', 'hood', 'door', 'fender', 'roof', 'paint', 'interior', 'seat'],
  'EF': ['engine', 'wiring', 'electrical', 'alternator', 'starter', 'fuel pump'],
  'EB': ['bumper', 'hood', 'door', 'fender', 'roof', 'paint', 'trim'],
  'IF': ['seat', 'dashboard', 'carpet', 'headliner', 'door panels', 'interior trim'],
  'TB': ['engine', 'transmission', 'frame', 'interior', 'electrical', 'all exterior parts']
};

function calculateRecommendationScore(partTitle, damageType) {
  if (!damageType || !partTitle) return 0;
  
  const keywords = window.damageKeywords[damageType.toUpperCase()] || [];
  if (keywords.length === 0) return 0;
  
  const titleLower = partTitle.toLowerCase();
  let matchedKeywords = 0;
  
  for (const keyword of keywords) {
    if (titleLower.includes(keyword.toLowerCase())) {
      matchedKeywords++;
    }
  }
  
  // Calculate percentage: matched / total keywords * 100
  const score = Math.round((matchedKeywords / keywords.length) * 100);
  return Math.min(score, 100);
}

function getRecommendationBadge(score, damageType) {
  let tooltip = 'Matches '+score+'% of parts related to '+damageType+' damage';
  if (score >= 80) {
    return '<span title="'+tooltip+'" style="background: #4CAF50; color: white; padding: 4px 10px; border-radius: 12px; font-size: 11px; font-weight: 600; display: inline-flex; align-items: center; gap: 4px; cursor: help;"><i class="fas fa-check-circle"></i> 🎯 Recommended ('+score+'%)</span>';
  } else if (score >= 60) {
    return '<span title="'+tooltip+'" style="background: #2196F3; color: white; padding: 4px 10px; border-radius: 12px; font-size: 11px; font-weight: 600; display: inline-flex; align-items: center; gap: 4px; cursor: help;"><i class="fas fa-star"></i> ⭐ Good Match ('+score+'%)</span>';
  } else if (score >= 40) {
    return '<span title="'+tooltip+'" style="background: #FF9800; color: white; padding: 4px 10px; border-radius: 12px; font-size: 11px; font-weight: 600; display: inline-flex; align-items: center; gap: 4px; cursor: help;"><i class="fas fa-cube"></i> 🎲 Possible Match ('+score+'%)</span>';
  }
  return '';
}

function getSellerBadge(feedback, topRated) {
  let badge = '';
  if (topRated) {
    badge += '<span style="background: #FF6B00; color: white; padding: 4px 8px; border-radius: 4px; font-size: 10px; font-weight: 600; display: inline-flex; align-items: center; gap: 3px;"><i class="fas fa-crown"></i> Top Rated</span> ';
  }
  if (feedback >= 98) {
    badge += '<span style="color: #4CAF50; font-weight: 600; display: inline-flex; align-items: center; gap: 2px;"><i class="fas fa-star" style="color: #FFB300;"></i> '+feedback+'%</span>';
  } else if (feedback >= 95) {
    badge += '<span style="color: #2196F3; font-weight: 600; display: inline-flex; align-items: center; gap: 2px;"><i class="fas fa-star" style="color: #FFB300;"></i> '+feedback+'%</span>';
  } else if (feedback > 0) {
    badge += '<span style="color: #999; font-weight: 600; display: inline-flex; align-items: center; gap: 2px;"><i class="fas fa-star" style="color: #FFB300;"></i> '+feedback+'%</span>';
  }
  return badge;
}

// Store search state for pagination
window.lastSearchParams = null;
window.currentPage = 1;

function getData(first=0){
    const user = getCurrentUser();
    if (!user) {
        alert('Please login to search for parts');
        showView('auth');
        return;
    }

    const listingData = window.currentListingData || { listingId: null, auctionSite: 'Unknown', country: 'US' };

    document.querySelector(".loader").style.display = "block";

    var sort_by = $("#sort_by").val();
    var car_search_key = $("#car_search_key").val();
    var car_make = $("#car_make").val();
    var price_min = $("#price_min").val() || '';
    var price_max = $("#price_max").val() || '';
    var condition = $("#condition").val() || '';
    var shipping_speed = $("#shipping_speed").val() || '';
    var item_location = $("#item_location").val() || '';
    var car_year = $("#car_year").val();
    
    var car_part = $("#car_part").val();
    
    var car_search_color = $("#car_search_color").val();
    var car_search_damage = $("#car_search_damage").val();
    var car_search_title = $("#car_search_title").val();
    
    // Fallback: if car_search_title is empty, try to get it from car_model
    if (!car_search_title || car_search_title.trim() === '') {
        car_search_title = $("#car_model").text().trim();
        if (car_search_title) {
            $("#car_search_title").val(car_search_title);
        }
    }
    
    // If still empty, show error
    if (!car_search_title || car_search_title.trim() === '') {
        document.querySelector(".loader").style.display = "none";
        alert('No car information found. Please make sure you are on a vehicle listing page.');
        return;
    }

    // Extract damage code (e.g., "FR" from "FR - Front")
    let damageCode = car_search_damage;
    if (car_search_damage) {
        const codeMatch = car_search_damage.match(/^([A-Z]{1,2})\s*-/);
        if (codeMatch) {
            damageCode = codeMatch[1];
        }
    }

    const currentPage = first || 1;
    window.currentPage = currentPage;

    const searchParams = {
        first: currentPage,
        car_part: car_part,
        car_search_color: car_search_color,
        car_search_damage: damageCode,
        car_search_title: car_search_title,
        sort_by: sort_by,
        car_search_key: car_search_key,
        car_make: car_make,
        car_year: car_year,
        price_min: price_min,
        price_max: price_max,
        condition: condition,
        shipping_speed: shipping_speed,
        item_location: item_location,
        listingId: listingData.listingId,
        auctionSite: listingData.auctionSite,
        country: listingData.country,
        page: currentPage
    };

    // Store search params for pagination
    window.lastSearchParams = searchParams;

    api.searchParts(searchParams).then(async result => {
        document.querySelector(".loader").style.display = "none";

        $("#resultdata").html("");
        
        // Check subscription and show/hide ads - silently handle errors
        checkSubscriptionAndShowAds().catch(() => {});
        
        if (result.upgradeRequired) {
            if (confirm(`You've reached your daily limit of ${result.limit} scans on the Free plan.\n\nUpgrade to Power Buyer for unlimited scans!\n\nClick OK to view pricing.`)) {
                showPricingView();
            }
            return;
        }

        if (result.usage && result.usage.remaining !== -1 && result.usage.remaining <= 3 && result.usage.remaining > 0) {
            console.log(`⚠️ ${result.usage.remaining} scans remaining today`);
        }
        
        if(result.status=="success")
        {
            if (result.isCached) {
                console.log('✅ Showing cached results (searched ' + result.searchCount + ' times)');
            }

            // Display market value for Power Buyer subscribers
            const carYear = $("#car_year").val();
            const carMake = $("#car_make").val();
            const carModel = $("#car_model").text().trim();
            const carMileage = $("#car_mileage").text().trim().replace(/,/g, '').split(' ')[0];
            const carDamage = $("#car_damage").text().trim();
            
            const user = getCurrentUser();
            if (user && carYear && carMake && carModel) {
                const userId = user.id;
                const cacheKey = `sub_${userId}`;
                const now = Date.now();
                
                let subscription;
                if (window.yopickySubscriptionCache && 
                    window.yopickySubscriptionCache[cacheKey] && 
                    (now - window.yopickySubscriptionCache[cacheKey].timestamp) < 60000) {
                    subscription = window.yopickySubscriptionCache[cacheKey].data;
                } else {
                    subscription = await api.getSubscriptionStatus().catch(() => null);
                    if (subscription && window.yopickySubscriptionCache) {
                        window.yopickySubscriptionCache[cacheKey] = {
                            data: subscription,
                            timestamp: now
                        };
                    }
                }
                
                if (subscription && subscription.plan === 'pro_monthly') {
                    api.getCarMarketValue({
                        year: carYear,
                        make: carMake,
                        model: carModel,
                        mileage: carMileage,
                        condition: 'Salvage',
                        damage: carDamage,
                        listingId: listingData.listingId || null
                    }).then(marketResult => {
                        if (marketResult.success) {
                            const marketHtml = `
                                <div style="margin: 10px 0; padding: 15px; background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%); border-radius: 10px; color: white;">
                                    <h3 style="margin: 0 0 8px 0; display: flex; align-items: center; gap: 8px;">
                                        <i class="fas fa-dollar-sign"></i> Market Value Estimate
                                    </h3>
                                    <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 12px; margin-bottom: 10px;">
                                        <div style="background: rgba(255,255,255,0.15); padding: 10px; border-radius: 6px;">
                                            <div style="font-size: 11px; opacity: 0.9;">Min Value</div>
                                            <div style="font-size: 16px; font-weight: bold;">$${marketResult.valueMin.toLocaleString()}</div>
                                        </div>
                                        <div style="background: rgba(255,255,255,0.15); padding: 10px; border-radius: 6px;">
                                            <div style="font-size: 11px; opacity: 0.9;">Avg Value</div>
                                            <div style="font-size: 16px; font-weight: bold;">$${Math.round(marketResult.avgValue).toLocaleString()}</div>
                                        </div>
                                        <div style="background: rgba(255,255,255,0.15); padding: 10px; border-radius: 6px;">
                                            <div style="font-size: 11px; opacity: 0.9;">Max Value</div>
                                            <div style="font-size: 16px; font-weight: bold;">$${marketResult.valueMax.toLocaleString()}</div>
                                        </div>
                                    </div>
                                    <div style="font-size: 11px; opacity: 0.85; line-height: 1.4;">
                                        <strong>Factors:</strong> ${marketResult.factors}<br>
                                        <strong>Assessment:</strong> ${marketResult.assessment}
                                    </div>
                                    ${marketResult.cached ? '<div style="margin-top: 8px; font-size: 10px; opacity: 0.8;"><i class="fas fa-bolt"></i> Instant cache (viewed ' + marketResult.lookups + ' times)</div>' : ''}
                                </div>
                            `;
                            $("#resultdata").prepend(marketHtml);
                        }
                    }).catch(err => console.warn('Market value error:', err));
                }
            }

            if (listingData.listingId) {
                api.getCommunityParts(listingData.listingId, 5).then(communityResult => {
                    if (communityResult.status === 'success' && communityResult.parts && communityResult.parts.length > 0) {
                        const communityHtml = `
                            <div style="margin: 10px 0; padding: 15px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 10px; color: white;">
                                <h3 style="margin: 0 0 10px 0; display: flex; align-items: center; gap: 8px;">
                                    <i class="fas fa-users"></i> Parts Other Users Saved (${communityResult.count})
                                </h3>
                                <div style="font-size: 12px; opacity: 0.9; margin-bottom: 10px;">Popular parts from this listing</div>
                                ${communityResult.parts.map(part => `
                                    <div style="background: rgba(255,255,255,0.15); padding: 8px; margin: 5px 0; border-radius: 6px; display: flex; justify-content: space-between; align-items: center;">
                                        <div style="flex: 1;">
                                            <div style="font-weight: bold;">${part.partData.partName}</div>
                                            <div style="font-size: 11px; opacity: 0.8;">${part.partData.price} • ${part.partData.condition}</div>
                                        </div>
                                        <div style="background: rgba(255,255,255,0.3); padding: 4px 10px; border-radius: 12px; font-size: 11px; font-weight: bold;">
                                            <i class="fas fa-heart"></i> ${part.saveCount}
                                        </div>
                                    </div>
                                `).join('')}
                            </div>
                        `;
                        $("#resultdata").append(communityHtml);
                    }
                }).catch(err => console.error('Community parts error:', err));
            }

            // Store current search context globally for save function - only if there are actual parts
                    if (result.data.length > 0) {
                        window.currentSearchContext = {
                            carModel: $("#car_model").text().trim(),
                            carColor: $("#car_color").text().trim(),
                            carDamage: $("#car_damage").text().trim(),
                            carMake: $("#car_make").val(),
                            carYear: $("#car_year").val(),
                            searchQuery: $("#car_search_title").val(),
                            auctionSite: $("#url_string").text(),
                            totalParts: result.data.length,
                            hasResults: true
                        };
                    } else {
                        // Clear context if no results
                        window.currentSearchContext = null;
                    }
                    
                    $.each(result.data, function(i, item) {
                        var partData = JSON.stringify({
                            partName: item.title || '',
                            price: item.price || '',
                            shippingCost: item.shippingCost || 'Free',
                            condition: item.condition || '',
                            year: item.car_year || '',
                            make: item.car_maker || '',
                            model: item.car_model || '',
                            damage: $("#car_damage").text().trim(),
                            url: item.part_href || '',
                            image: item.image || '',
                            listingId: listingData.listingId || '',
                            partId: item.itemId || `part_${i}`,
                            carYear: $("#car_year").val() || '',
                            carMake: $("#car_make").val() || '',
                            carModel: $("#car_model").text().trim() || '',
                            carMileage: $("#car_mileage").text().trim().replace(/,/g, '').split(' ')[0] || ''
                        }).replace(/'/g, "&#39;");
                        
                        // Calculate recommendation score
                        const damageType = $("#car_damage").text().trim();
                        const score = calculateRecommendationScore(item.title, damageType);
                        const badge = getRecommendationBadge(score, damageType);
                        const sellerBadge = getSellerBadge(item.sellerFeedbackPercentage || 0, item.topRated || false);
                        
                        var html = '<div class="category-inner-fix" >'+
                                '<div class="category-box design-1 search-result-part" data-part-info=\''+partData+'\' data-recommendation-score="'+score+'"> '+
                                '<div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 8px;">'+
                                '<div style="flex: 1;">'+
                                '<a href="'+item.part_href+'" target="_blank" style="flex: 1;"><h4 class="car-name" style="margin: 0 0 6px 0;">'+item.title+'</h4></a>'+
                                (badge ? '<div style="margin-bottom: 6px;">'+badge+'</div>' : '')+
                                '</div>'+
                                '<div style="display: flex; gap: 6px;">'+
                                '<button class="save-to-collection-btn" style="background: #2196F3; color: white; border: none; padding: 6px 10px; border-radius: 6px; cursor: pointer; font-size: 11px; white-space: nowrap;">'+
                                '<i class="fas fa-save"></i> Save'+
                                '</button>'+
                                '</div>'+
                                '</div>'+
                                '<div class="car-details" >'+
                                '<div class="car-image" >'+
                                '<img src="'+item.image+'" >'+
                                '</div >'+
                                '<div class="car-detail-list" >'+
                                '<div class="car-detail-list-item">Condition : <span class="value">'+ item.condition+'</span></div> '+
                                '<div class="car-detail-list-item">Year : <span class="value">'+ item.car_year+'</span></div> '+
                                '<div class="car-detail-list-item">Make : <span class="value">'+ item.car_maker+'</span></div> '+
                                '<div class="car-detail-list-item">Model : <span class="value">'+item.car_model+'</span></div>  '+
                                '<div class="car-detail-list-item">Shipping : <span class="value" style="color: #4CAF50; font-weight: 600;"><i class="fas fa-truck"></i> '+item.shippingCost+'</span></div>'+
                                (item.seller ? '<div class="car-detail-list-item">Seller : <span class="value">'+item.seller+(sellerBadge ? ' <span style="margin-left: 6px;">'+sellerBadge+'</span>' : '')+'</span></div>' : '')+
                                '</div>  '+
                                '<div class="car-detail-price">'+item.price+'</div>    '+
                                '</div>  '+
                                '</div>  '+
                                '</div>  ';
                        const div = document.createElement('div');
                        div.innerHTML = html;
                        document.getElementById('resultdata').appendChild(div.firstChild);
                    });

                    // Add pagination controls after results
                    if (result.data.length > 0) {
                        const paginationHtml = `
                            <div style="display: flex; justify-content: center; align-items: center; gap: 12px; padding: 20px; margin-top: 20px; background: #f5f5f5; border-radius: 8px;">
                                <button id="prevPageBtn" class="pagination-btn" style="background: linear-gradient(135deg, #2196F3 0%, #1976D2 100%); color: white; border: none; padding: 10px 16px; border-radius: 6px; cursor: pointer; font-size: 12px; font-weight: 500; ${window.currentPage <= 1 ? 'opacity: 0.5; cursor: not-allowed;' : ''}">
                                    <i class="fas fa-chevron-left"></i> Previous
                                </button>
                                <span style="font-weight: 600; color: #666;">Page ${window.currentPage}</span>
                                <button id="nextPageBtn" class="pagination-btn" style="background: linear-gradient(135deg, #2196F3 0%, #1976D2 100%); color: white; border: none; padding: 10px 16px; border-radius: 6px; cursor: pointer; font-size: 12px; font-weight: 500; ${result.data.length < 50 ? 'opacity: 0.5; cursor: not-allowed;' : ''}">
                                    Next <i class="fas fa-chevron-right"></i>
                                </button>
                            </div>
                        `;
                        $("#resultdata").append(paginationHtml);

                        // Add click handlers for pagination
                        document.getElementById('prevPageBtn').addEventListener('click', function() {
                            if (window.currentPage > 1) {
                                getData(window.currentPage - 1);
                                window.scrollTo(0, 0);
                            }
                        });

                        document.getElementById('nextPageBtn').addEventListener('click', function() {
                            if (result.data.length >= 50) {
                                getData(window.currentPage + 1);
                                window.scrollTo(0, 0);
                            }
                        });
                    }
                    
                    // Add event listeners for AI repair cost buttons
                    document.querySelectorAll('.ai-repair-cost-btn').forEach(btn => {
                        btn.addEventListener('click', async function(e) {
                            e.preventDefault();
                            
                            if (this.disabled || this.dataset.inFlight === 'true') return;
                            
                            const partBox = this.closest('.category-box');
                            const partInfo = JSON.parse(partBox.getAttribute('data-part-info'));
                            
                            const user = getCurrentUser();
                            if (!user) {
                                alert('Please login to use AI repair cost estimates');
                                showView('auth');
                                return;
                            }
                            
                            const originalText = this.innerHTML;
                            const originalDisabled = this.disabled;
                            
                            const resetButton = () => {
                                this.disabled = originalDisabled;
                                this.innerHTML = originalText;
                                this.dataset.inFlight = 'false';
                            };
                            
                            this.disabled = true;
                            this.dataset.inFlight = 'true';
                            this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Checking...';
                            
                            try {
                                if (!window.yopickySubscriptionCache) {
                                    window.yopickySubscriptionCache = {};
                                }
                                
                                const userId = user.id;
                                const cacheKey = `sub_${userId}`;
                                const now = Date.now();
                                
                                let subscription;
                                if (window.yopickySubscriptionCache[cacheKey] && 
                                    (now - window.yopickySubscriptionCache[cacheKey].timestamp) < 60000) {
                                    subscription = window.yopickySubscriptionCache[cacheKey].data;
                                } else {
                                    subscription = await api.getSubscriptionStatus();
                                    window.yopickySubscriptionCache[cacheKey] = {
                                        data: subscription,
                                        timestamp: now
                                    };
                                }
                                
                                if (!subscription.features || !subscription.features.aiRepairCost) {
                                    resetButton();
                                    
                                    if (confirm('AI repair cost estimates are only available for Power Buyer subscribers.\n\nUpgrade now to unlock this feature?')) {
                                        showPricingView();
                                    }
                                    return;
                                }
                                
                                this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Analyzing...';
                                
                                const estimate = await api.getRepairCostEstimate({
                                    partName: partInfo.partName,
                                    make: partInfo.make || '',
                                    model: partInfo.model || '',
                                    year: partInfo.year || '',
                                    condition: partInfo.condition || '',
                                    damage: partInfo.damage || ''
                                });
                                
                                if (estimate.success) {
                                    const costRange = estimate.costMin === estimate.costMax 
                                        ? `$${estimate.costMin}` 
                                        : `$${estimate.costMin} - $${estimate.costMax}`;
                                    
                                    alert(`AI Repair Cost Estimate\n\n` +
                                          `Part: ${partInfo.partName}\n\n` +
                                          `Estimated Cost: ${costRange}\n\n` +
                                          `${estimate.explanation}\n\n` +
                                          `Recommendation: ${estimate.recommendation}`);
                                } else {
                                    const errorMsg = estimate.error || 'Unable to generate estimate at this time. Please try again later.';
                                    alert(errorMsg);
                                }
                            } catch (error) {
                                console.error('AI repair cost error:', error);
                                
                                if (error.upgradeRequired) {
                                    resetButton();
                                    if (confirm('AI repair cost estimates are only available for Power Buyer subscribers.\n\nUpgrade now to unlock this feature?')) {
                                        showPricingView();
                                    }
                                    return;
                                } else {
                                    const errorMsg = error.error || error.message || 'Failed to get repair cost estimate. Please try again.';
                                    alert(errorMsg);
                                }
                            } finally {
                                resetButton();
                            }
                        });
                    });
                    
                    // Add event listeners for save buttons
                    document.querySelectorAll('.save-to-collection-btn').forEach(btn => {
                        btn.addEventListener('click', function(e) {
                            e.preventDefault();
                            const partBox = this.closest('.category-box');
                            const partInfo = JSON.parse(partBox.getAttribute('data-part-info'));
                            
                            if (typeof showSaveToCollectionModal === 'function') {
                                showSaveToCollectionModal(partInfo);
                            } else {
                                alert('Please login to save parts to collections');
                            }
                        });
                    });
                    
                    // Update UI to show/hide save button based on results
                    if (typeof updateAuthUI === 'function') {
                        updateAuthUI(); // This will show/hide save button based on currentSearchContext
                    }
            //$("#resultdata").append(result.sql);
            //
        } else {
            // Clear search context and update UI on error
            window.currentSearchContext = null;
            if (typeof updateAuthUI === 'function') {
                updateAuthUI(); // This will hide the save button
            }
            
            $("#resultdata").html('<div class="category-inner-fix" >'+
                        '<div class="category-box design-1"  > '+
                        '<h4 class="car-name">'+result.message+'</h4></div></div>');
            //alert(result.message) 
        }
         
        $("#car_part").val();
        $("#car_part").html(result.cpdata); 
    }).catch(error => {
        document.querySelector(".loader").style.display = "none";
        
        // Clear search context on error
        window.currentSearchContext = null;
        if (typeof updateAuthUI === 'function') {
            updateAuthUI();
        }
        
        console.error('Parts API Error:', error);
        $("#resultdata").html('<div class="category-inner-fix" >'+
            '<div class="category-box design-1"  > '+
            '<h4 class="car-name error">'+error.message+'</h4></div></div>');
    });
}
function DOMtoString(selector) {
     
    /*if (selector) {
        selector = document.querySelector(selector);
        if (!selector) return "ERROR: querySelector failed to find node"
    } else {
        selector = document.documentElement;
    }*/
    
    //selector = document.documentElement;
    
    var title ='';
    var color ='';
    var damage = '';
    var mileage = '';
     
    if(selector=="iaai"){ 
        // Get title
        if(document.querySelector(".vehicle-header h1")){
            title = document.querySelector(".vehicle-header h1").innerText
        }
        
        // Get color, damage, and mileage from data list items
        if(document.querySelectorAll('ul li.data-list__item')){ 
            var colort = document.querySelectorAll('ul li.data-list__item').forEach(function(el) { 
              if(el.querySelector(".data-list__label") && el.querySelector(".data-list__label").innerText == "Exterior/Interior:"){
                color =  el.querySelector(".data-list__value").innerText;
              }
              if(el.querySelector(".data-list__label") && el.querySelector(".data-list__label").innerText == "Primary Damage:"){
                // Try specific ID first
                let damageElement = el.querySelector(".data-list__value#startPrimaryDamageVideo_novideo");
                if(damageElement){
                  damage = damageElement.innerText;
                } else {
                  // Fallback: get any data-list__value within this item
                  let fallbackElement = el.querySelector(".data-list__value");
                  if(fallbackElement){
                    damage = fallbackElement.innerText;
                  }
                }
              }
              // Extract mileage/odometer
              if(el.querySelector(".data-list__label") && (el.querySelector(".data-list__label").innerText.includes("Odometer") || el.querySelector(".data-list__label").innerText.includes("Miles"))){
                let mileageElement = el.querySelector(".data-list__value");
                if(mileageElement){
                  mileage = mileageElement.innerText.replace(/[^0-9]/g, '');
                }
              }
            }) 
        }
        
        // Fallback: search page text for damage info
        if(!damage){
            let allText = document.body.innerText;
            let damageMatch = allText.match(/Primary Damage:\s*([^\n]+)/i);
            if(damageMatch) damage = damageMatch[1].trim();
        }
        
        // Fallback: search page text for mileage
        if(!mileage){
            let allText = document.body.innerText;
            let mileageMatch = allText.match(/Odometer[:\s]*([0-9,]+)/i);
            if(mileageMatch) mileage = mileageMatch[1].replace(/[^0-9]/g, '');
        }

        return {"title":title,"color":color,"damage":damage,"mileage":mileage};
    }else if(selector=="copart"){
        // Try primary title selector
        if(document.querySelector("h1.title")){
            title = document.querySelector("h1.title").innerText
        }
        // Fallback: look for h1 with lot info
        if(!title && document.querySelector("h1[class*='title']")){
            title = document.querySelector("h1[class*='title']").innerText
        }
        // Fallback: look for any h1 that might contain vehicle info
        if(!title){
            let h1s = document.querySelectorAll("h1");
            if(h1s.length > 0) title = h1s[0].innerText;
        }
        
        // Try primary color selector
        if(document.querySelector(".lot-details-desc[data-uname='lotdetailColorvalue']")){
            color = document.querySelector(".lot-details-desc[data-uname='lotdetailColorvalue']").innerText
        }
        // Fallback: look for color in vehicle description section
        if(!color){
            let colorSection = document.querySelector("[data-uname*='Color']");
            if(colorSection) color = colorSection.innerText.replace("Color:", "").trim();
        }
        // Fallback: search for color-related text in lot details
        if(!color){
            let allText = document.body.innerText;
            let colorMatch = allText.match(/Color:\s*([^\n]+)/i);
            if(colorMatch) color = colorMatch[1].trim();
        }
        
        // Parse Exterior Condition section (new Copart format)
        // Look for damage organized by Front left, Front right, Rear left, Rear right, Other
        let damageAreas = [];
        let pageText = document.body.innerText;
        
        // Extract damage from each area
        let frontLeftMatch = pageText.match(/Front\s*left[\s\S]*?(?=Front\s*right|Rear\s*left|Rear\s*right|Other|$)/i);
        if(frontLeftMatch){
            let text = frontLeftMatch[0];
            // Get all damage items (skip the header)
            let damageItems = text.split('\n').slice(1).filter(line => line.trim().length > 0 && !line.includes('Front left'));
            if(damageItems.length > 0) damageAreas.push('FL'); // Front Left code
        }
        
        let frontRightMatch = pageText.match(/Front\s*right[\s\S]*?(?=Rear\s*left|Rear\s*right|Other|$)/i);
        if(frontRightMatch){
            let text = frontRightMatch[0];
            let damageItems = text.split('\n').slice(1).filter(line => line.trim().length > 0 && !line.includes('Front right'));
            if(damageItems.length > 0) damageAreas.push('FR'); // Front Right code
        }
        
        let rearLeftMatch = pageText.match(/Rear\s*left[\s\S]*?(?=Rear\s*right|Other|$)/i);
        if(rearLeftMatch){
            let text = rearLeftMatch[0];
            let damageItems = text.split('\n').slice(1).filter(line => line.trim().length > 0 && !line.includes('Rear left'));
            if(damageItems.length > 0) damageAreas.push('LR'); // Left Rear code
        }
        
        let rearRightMatch = pageText.match(/Rear\s*right[\s\S]*?(?=Other|$)/i);
        if(rearRightMatch){
            let text = rearRightMatch[0];
            let damageItems = text.split('\n').slice(1).filter(line => line.trim().length > 0 && !line.includes('Rear right'));
            if(damageItems.length > 0) damageAreas.push('RR'); // Right Rear code
        }
        
        // If we found damage areas, use the most severe (typically Front Right/Left first)
        if(damageAreas.length > 0){
          // Prioritize front damage
          if(damageAreas.includes('FR')) damage = 'FR - Front Right';
          else if(damageAreas.includes('FL')) damage = 'FL - Front Left';
          else if(damageAreas.includes('RR')) damage = 'RR - Rear Right';
          else if(damageAreas.includes('LR')) damage = 'LR - Rear Left';
        }
        
        // Fallback: try old method
        if(!damage){
            if(document.querySelector(".lot-details-desc[data-uname='lotdetailPrimarydamagevalue']")){
                damage = document.querySelector(".lot-details-desc[data-uname='lotdetailPrimarydamagevalue']").innerText
            }
        }
        // Fallback: search for damage-related text
        if(!damage){
            let allText = document.body.innerText;
            let damageMatch = allText.match(/Primary Damage:\s*([^\n]+)/i);
            if(damageMatch) damage = damageMatch[1].trim();
        }
        
        // Extract mileage from Copart
        if(document.querySelector(".lot-details-desc[data-uname='lotdetailOdometervalue']")){
            mileage = document.querySelector(".lot-details-desc[data-uname='lotdetailOdometervalue']").innerText.replace(/[^0-9]/g, '');
        }
        // Fallback: search for mileage in page text
        if(!mileage){
            let allText = document.body.innerText;
            let mileageMatch = allText.match(/Odometer[:\s]*([0-9,]+)/i);
            if(mileageMatch) mileage = mileageMatch[1].replace(/[^0-9]/g, '');
        }
        
        return {"title":title,"color":color,"damage":damage,"mileage":mileage};
    }else if(selector=="autobidmaster"){
        // Try primary title selector
        if(document.querySelector("h1#text_title_f_lot")){
            title = document.querySelector("h1#text_title_f_lot").innerText
        }
        // Fallback: look for any h1
        if(!title){
            let h1s = document.querySelectorAll("h1");
            if(h1s.length > 0) title = h1s[0].innerText;
        }
        // Fallback: look in page title
        if(!title && document.title){
            title = document.title.split('|')[0].split('-')[0].trim();
        }
        
        // Try primary extraction from details divs
        if(document.querySelectorAll('div.qa_all_details')){ 
            document.querySelectorAll('div.qa_all_details ._EFAe-root, div.qa_all_details [class*="_EFAe"]').forEach(function(el) { 
              let label = el.querySelector("._EFAe-label, [class*='label']");
              let value = el.querySelector("._EFAe-value, [class*='value']");
              
              if(label && value){
                let labelText = label.innerText.trim();
                let valueText = value.innerText.trim();
                
                if(labelText.includes("Color") && !color){
                    color = valueText;
                }
                if(labelText.includes("Primary Damage") && !damage){
                    damage = valueText;
                }
              }
            }) 
        }
        
        // Fallback: search for details in any structured list/section
        if(!color || !damage){
            let allDivs = document.querySelectorAll('[class*="detail"], [class*="info"], [class*="spec"]');
            allDivs.forEach(function(div){
                let text = div.innerText;
                if(text.includes("Color:") && !color){
                    let match = text.match(/Color:\s*([^\n]+)/i);
                    if(match) color = match[1].trim();
                }
                if(text.includes("Primary Damage:") && !damage){
                    let match = text.match(/Primary Damage:\s*([^\n]+)/i);
                    if(match) damage = match[1].trim();
                }
            });
        }
        
        // Final fallback: search entire page text
        if(!color || !damage){
            let allText = document.body.innerText;
            
            if(!color){
                let colorMatch = allText.match(/Color:\s*([^\n]+)/i);
                if(colorMatch) color = colorMatch[1].trim();
            }
            
            if(!damage){
                let damageMatch = allText.match(/Primary Damage:\s*([^\n]+)/i);
                if(damageMatch) damage = damageMatch[1].trim();
            }
        }
        
        // Extract mileage from AutoBidMaster
        let allText = document.body.innerText;
        let mileageMatch = allText.match(/Odometer[:\s]*([0-9,]+)/i);
        if(mileageMatch) mileage = mileageMatch[1].replace(/[^0-9]/g, '');
        if(!mileage){
            mileageMatch = allText.match(/Mileage[:\s]*([0-9,]+)/i);
            if(mileageMatch) mileage = mileageMatch[1].replace(/[^0-9]/g, '');
        }

        return {"title":title,"color":color,"damage":damage,"mileage":mileage};
    }
    else if(selector=="erepairables"){
        // Get title - try multiple selectors
        if(document.querySelector("h1.uk-text-bold")){
            title = document.querySelector("h1.uk-text-bold").innerText
        }
        // Fallback: look for any h1
        if(!title){
            let h1s = document.querySelectorAll("h1");
            if(h1s.length > 0) title = h1s[0].innerText;
        }
        
        // Try structured table extraction
        let foundColor = false;
        let primaryDamage = '';
        let secondaryDamage = '';
        
        if(document.querySelectorAll('table tbody tr')){ 
            document.querySelectorAll('table tbody tr').forEach(function(row) { 
                let cells = row.querySelectorAll('td');
                if(cells.length >= 2){
                    let label = cells[0].innerText.trim();
                    let value = cells[1].innerText.trim();
                    
                    if(label.includes("Exterior Color") && !foundColor){
                        color = value;
                        foundColor = true;
                    }
                    if(label.includes("Primary Damage") && !primaryDamage){
                        primaryDamage = value;
                    }
                    if(label.includes("Secondary Damage") && !secondaryDamage){
                        secondaryDamage = value;
                    }
                }
            }) 
        }
        
        // Use primary damage if available, otherwise use secondary
        if(primaryDamage){
            damage = primaryDamage;
        } else if(secondaryDamage){
            damage = secondaryDamage;
        }
        
        // Fallback: search page text for damage and color
        if(!color || !damage){
            let allText = document.body.innerText;
            
            if(!color){
                let colorMatch = allText.match(/Exterior Color:\s*([^\n]+)/i);
                if(colorMatch) color = colorMatch[1].trim();
            }
            
            if(!damage){
                let primaryMatch = allText.match(/Primary Damage:\s*([^\n]+)/i);
                if(primaryMatch){
                    damage = primaryMatch[1].trim();
                } else {
                    let secondaryMatch = allText.match(/Secondary Damage:\s*([^\n]+)/i);
                    if(secondaryMatch) damage = secondaryMatch[1].trim();
                }
            }
        }
        
        // Extract mileage from eRepairables
        let allText = document.body.innerText;
        let mileageMatch = allText.match(/Odometer[:\s]*([0-9,]+)/i);
        if(mileageMatch) mileage = mileageMatch[1].replace(/[^0-9]/g, '');
        if(!mileage){
            mileageMatch = allText.match(/Mileage[:\s]*([0-9,]+)/i);
            if(mileageMatch) mileage = mileageMatch[1].replace(/[^0-9]/g, '');
        }
        
        return {"title":title,"color":color,"damage":damage,"mileage":mileage};
    }else if(selector=="sca"){
        // Try primary title selector
        if(document.querySelector("h1#lotLabel")){
            title = document.querySelector("h1#lotLabel").innerText
        }
        // Fallback: look for any h1
        if(!title){
            let h1s = document.querySelectorAll("h1");
            if(h1s.length > 0) title = h1s[0].innerText;
        }
        // Fallback: look in page title
        if(!title && document.title){
            title = document.title.split('|')[0].trim();
        }
        
        // Try to find Primary Damage and Secondary Damage
        let primaryDamage = '';
        let secondaryDamage = '';
        
        if(document.querySelectorAll('section#lotVahicleInfo')){ 
            var colort = document.querySelectorAll('section#lotVahicleInfo .panel-info-v2__list .panel-info-v2__item').forEach(function(el) { 
              if(el.querySelector(".info-v2") && el.querySelector(".info-v2").innerText == "Primary Damage"){
                primaryDamage =  el.querySelector(".panel-info-v2__desc").innerText;
              }
              if(el.querySelector(".info-v2") && el.querySelector(".info-v2").innerText == "Secondary Damage"){
                secondaryDamage =  el.querySelector(".panel-info-v2__desc").innerText;
              }
            }) 
        }
        
        // Use primary damage if available, otherwise use secondary
        if(primaryDamage){
            damage = primaryDamage;
        } else if(secondaryDamage){
            damage = secondaryDamage;
        }
        
        // Fallback: search for damage text
        if(!damage){
            let allText = document.body.innerText;
            let primaryMatch = allText.match(/Primary Damage:\s*([^\n]+)/i);
            if(primaryMatch){
                damage = primaryMatch[1].trim();
            } else {
                let secondaryMatch = allText.match(/Secondary Damage:\s*([^\n]+)/i);
                if(secondaryMatch) damage = secondaryMatch[1].trim();
            }
        }
        
        // Try primary color selector
        if(document.querySelectorAll('section#lotVehicleDesc')){ 
            var colort = document.querySelectorAll('section#lotVehicleDesc .panel-info-v2__list .panel-info-v2__item').forEach(function(el) { 
              if(el.querySelector(".panel-info-v2__term") && el.querySelector(".panel-info-v2__term").innerText == "Exterior Color"){
                color =  el.querySelector(".panel-info-v2__desc").innerText;
              }
              
            }) 
        }
        // Fallback: search for color text
        if(!color){
            let allText = document.body.innerText;
            let colorMatch = allText.match(/Exterior Color:\s*([^\n]+)/i);
            if(colorMatch) color = colorMatch[1].trim();
        }
        
        // Extract mileage from SCA
        let allText = document.body.innerText;
        let mileageMatch = allText.match(/Odometer[:\s]*([0-9,]+)/i);
        if(mileageMatch) mileage = mileageMatch[1].replace(/[^0-9]/g, '');
        if(!mileage){
            mileageMatch = allText.match(/Mileage[:\s]*([0-9,]+)/i);
            if(mileageMatch) mileage = mileageMatch[1].replace(/[^0-9]/g, '');
        }
        
        return {"title":title,"color":color,"damage":damage,"mileage":mileage};
    }else{
        return false;
    }
    //return selector.outerHTML;
    //return url; 
} 
/*
$(function() {
    $('#btn_check').click(function() { checkCurrentTab(); });
});

function checkCurrentTab() {
    chrome.tabs.query({'active': true, 'lastFocusedWindow': true}, function (tabs) {
        var url = tabs[0].url;
        console.log("checkCurrentTab: "+url);
        $(".pg_url").text(url);

        // request content_script to retrieve title element innerHTML from current tab
        chrome.tabs.sendMessage(tabs[0].id, "getHeadTitle", null, function(obj) {
            console.log("getHeadTitle.from content_script:", obj);
            log("from content_script:"+obj);
        });

    });
}

// Initialize UI on page load
document.addEventListener('DOMContentLoaded', function () {
    // Show main view by default
    showView('main');
    
    // Initialize auth UI - show Login button or user menu
    updateAuthUI();
    
    // Verify token and restore session if available
    verifyToken().then(user => {
        if (user) {
            updateAuthUI();
        }
    }).catch(err => {
        console.log('No active session');
    });
    
    // Content script injection for active tab
    try {
        chrome.windows.getCurrent(function (currentWindow) {
            chrome.tabs.query({active: true, windowId: currentWindow.id}, function(activeTabs) {
                if (activeTabs.length > 0) {
                    chrome.tabs.executeScript(activeTabs[0].id, {file: 'content_script.js', allFrames: false});
                }
            });
        });
    } catch(e) {
        console.log('Chrome tabs API not available');
    }
});

function log(txt) {
    var h = $("#log").html();
    $("#log").html(h+"<br>"+txt);
}
*/
// Toggle filters visibility
function toggleFilters() {
    const container = document.getElementById('filtersContainer');
    const btn = document.getElementById('filterToggleBtn');
    const icon = btn.querySelector('i');
    
    const isCollapsed = container.style.maxHeight === '0px' || container.style.maxHeight === '0';
    
    if (isCollapsed) {
        // Expand
        container.style.maxHeight = '500px';
        container.style.opacity = '1';
        container.style.overflow = 'visible';
        icon.classList.remove('fa-chevron-down');
        icon.classList.add('fa-chevron-up');
    } else {
        // Collapse
        container.style.maxHeight = '0px';
        container.style.opacity = '0';
        container.style.overflow = 'hidden';
        icon.classList.remove('fa-chevron-up');
        icon.classList.add('fa-chevron-down');
    }
}

// Toggle car info visibility
function toggleCarInfo() {
    const header = document.getElementById('carInfoHeader');
    const btn = document.getElementById('carInfoToggleBtn');
    const icon = btn.querySelector('i');
    const text = btn.querySelector('span') || btn;
    
    const isCollapsed = header.style.maxHeight === '0px' || header.style.maxHeight === '0';
    
    if (isCollapsed) {
        // Expand
        header.style.maxHeight = '200px';
        header.style.opacity = '1';
        header.style.overflow = 'visible';
        icon.classList.remove('fa-chevron-down');
        icon.classList.add('fa-chevron-up');
        btn.textContent = '';
        btn.innerHTML = '<i class="fas fa-chevron-up"></i> Collapse';
        localStorage.setItem('yopicky_car_info_collapsed', 'false');
    } else {
        // Collapse
        header.style.maxHeight = '0px';
        header.style.opacity = '0';
        header.style.overflow = 'hidden';
        icon.classList.remove('fa-chevron-up');
        icon.classList.add('fa-chevron-down');
        btn.textContent = '';
        btn.innerHTML = '<i class="fas fa-chevron-down"></i> Expand';
        localStorage.setItem('yopicky_car_info_collapsed', 'true');
    }
}

let upgradePollingInterval = null;

async function handleUpgrade() {
    const user = getCurrentUser();
    if (!user) {
        alert('Please login first to upgrade your plan.');
        showView('auth');
        return;
    }
    
    try {
        const plans = await api.getPlans();
        const priceId = plans.plans?.pro_monthly?.stripePriceId;
        
        if (!priceId) {
            alert('Subscription service is temporarily unavailable. Please try again later.');
            console.error('Price ID not found in plans:', plans);
            return;
        }
        
        const { url } = await api.createCheckoutSession(priceId);
        if (url) {
            window.open(url, '_blank');
            startUpgradePolling();
        } else {
            alert('Failed to start checkout. Please try again.');
        }
    } catch (error) {
        console.error('Upgrade error:', error);
        alert('Failed to process upgrade. Please try again.');
    }
}

function startUpgradePolling() {
    if (upgradePollingInterval) {
        clearInterval(upgradePollingInterval);
    }
    
    let pollCount = 0;
    const maxPolls = 60;
    
    upgradePollingInterval = setInterval(async () => {
        pollCount++;
        
        if (pollCount > maxPolls) {
            clearInterval(upgradePollingInterval);
            upgradePollingInterval = null;
            return;
        }
        
        try {
            if (window.yopickySubscriptionCache) {
                const token = localStorage.getItem('yopicky_token');
                if (token) {
                    const payload = JSON.parse(atob(token.split('.')[1]));
                    const cacheKey = `sub_${payload.userId}`;
                    delete window.yopickySubscriptionCache[cacheKey];
                }
            }
            
            const subscription = await api.getSubscriptionStatus();
            
            if (subscription && subscription.plan === 'pro_monthly') {
                clearInterval(upgradePollingInterval);
                upgradePollingInterval = null;
                
                if (typeof updateAuthUI === 'function') {
                    updateAuthUI();
                }
                
                if (!window.upgradeSuccessShown) {
                    window.upgradeSuccessShown = true;
                    showUpgradeSuccessNotification();
                }
                
                return;
            }
        } catch (error) {
        }
    }, 5000);
}

function showUpgradeSuccessNotification() {
    const existingNotification = document.getElementById('upgrade-notification');
    if (existingNotification) {
        existingNotification.remove();
    }
    
    const notification = document.createElement('div');
    notification.id = 'upgrade-notification';
    notification.style.cssText = 'position: fixed; top: 10px; left: 10px; right: 10px; background: linear-gradient(135deg, #4CAF50, #45a049); color: white; padding: 12px; border-radius: 8px; text-align: center; font-weight: 500; z-index: 10000; box-shadow: 0 4px 12px rgba(0,0,0,0.3);';
    notification.innerHTML = '🎉 Welcome to Power Buyer! Unlimited scans unlocked.';
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.remove();
    }, 8000);
}

function updateHeaderForPowerBuyer(isPowerBuyer) {
    const authButtons = document.getElementById('auth-buttons');
    if (!authButtons) return;
    
    const existingBadge = document.getElementById('power-buyer-badge');
    if (existingBadge) {
        existingBadge.remove();
    }
    
    if (isPowerBuyer) {
        const upgradeBtn = authButtons.querySelector('.upgrade-btn');
        if (upgradeBtn) {
            upgradeBtn.style.display = 'none';
        }
        
        const badge = document.createElement('span');
        badge.id = 'power-buyer-badge';
        badge.style.cssText = 'background: linear-gradient(135deg, #FFD700, #FFA500); color: #333; padding: 4px 8px; border-radius: 12px; font-size: 10px; font-weight: 600; white-space: nowrap;';
        badge.textContent = 'POWER BUYER';
        
        const logoutBtn = authButtons.querySelector('.logout-btn');
        if (logoutBtn) {
            authButtons.insertBefore(badge, logoutBtn);
        } else {
            authButtons.appendChild(badge);
        }
    }
}
