# Yopicky Chrome Extension

A Chrome extension that helps users find car parts instantly while browsing auto auction sites (IAAI, Copart, SCA Auction, eRepairables, AutoBidMaster). The extension extracts vehicle details from auction pages and searches for matching parts with one click.

## Features

- **Automatic Vehicle Detection**: Extracts car details (year, make, model, color, damage) from auction pages
- **Real-time Parts Search**: Searches for matching parts based on vehicle information
- **User Authentication**: Register and login to save your searches
- **Saved Searches**: Save parts searches organized by car name for easy access later
- **Filter & Sort**: Filter by year, make, keywords and sort results by price
- **Modern UI**: Blue gradient design with glassmorphism effects

## Supported Auction Sites

- IAAI (www.iaai.com)
- Copart (www.copart.com)
- SCA Auction (sca.auction)
- eRepairables (erepairables.com)
- AutoBidMaster (www.autobidmaster.com)

## Installation

### For Development

1. **Install Dependencies**
   ```bash
   npm install
   ```

2. **Set Up Database**
   - A PostgreSQL database is required
   - Set the `DATABASE_URL` environment variable
   - Push the schema to the database:
   ```bash
   npm run db:push
   ```

3. **Configure Environment Variables**
   - `DATABASE_URL` - PostgreSQL connection string (required)
   - `JWT_SECRET` - Secret key for JWT tokens (strongly recommended for production)
   
   **Important**: For production deployment, always set a secure `JWT_SECRET` environment variable. You can generate one with:
   ```bash
   node -e "console.log(require('crypto').randomBytes(64).toString('hex'))"
   ```

4. **Start the Server**
   ```bash
   npm start
   ```
   
   The server will run on port 5000 and provides:
   - Demo page at `http://localhost:5000`
   - API endpoints at `http://localhost:5000/api`
   - Extension download at `http://localhost:5000/download`

### Installing the Chrome Extension

1. Download the extension files from the server
2. Extract the ZIP file to a folder on your computer
3. Open Chrome and navigate to `chrome://extensions/`
4. Enable "Developer mode" (toggle in top-right corner)
5. Click "Load unpacked"
6. Select the extracted folder
7. The extension will appear in your browser toolbar

## Usage

1. **Browse an Auction Site**: Navigate to a vehicle detail page on any supported auction site
2. **Click the Extension Icon**: The extension will automatically extract vehicle information
3. **Search for Parts**: The extension automatically searches for matching parts
4. **Filter Results**: Use the filters to narrow down results by make, year, or keywords
5. **Save Searches** (requires login):
   - Click "Login" in the extension popup
   - Register a new account or login
   - Click "Save This Search" to save the current results
   - Access saved searches by clicking "My Searches"

## Architecture

### Backend (Node.js + Express)

- **Database**: PostgreSQL with Drizzle ORM
- **Authentication**: JWT-based authentication with bcrypt password hashing
- **API Routes**:
  - `POST /api/auth/register` - Register new user
  - `POST /api/auth/login` - Login user
  - `GET /api/auth/verify` - Verify JWT token
  - `POST /api/searches/save` - Save a search (protected)
  - `GET /api/searches` - Get user's saved searches (protected)
  - `DELETE /api/searches/:id` - Delete a saved search (protected)

### Frontend (Chrome Extension)

- **Manifest V3**: Modern Chrome extension architecture
- **Content Scripts**: Extract vehicle data from auction pages
- **Popup UI**: React-like view management (main, auth, saved searches)
- **API Client**: Fetch-based API communication with JWT authentication
- **Local Storage**: Persists JWT tokens for authenticated sessions

### Database Schema

- **users**: User accounts with bcrypt-hashed passwords
- **saved_searches**: Car parts searches linked to users
- **sessions**: Express session storage

## API Base URL Configuration

For development, the extension uses `http://localhost:5000/api`. For production deployment:

1. Update `API_BASE_URL` in `assets/js/api.js` to your deployed server URL
2. Ensure CORS is properly configured in `server.js`

## Security Notes

⚠️ **Important for Production**:
- Always set a secure `JWT_SECRET` environment variable
- Use HTTPS for your deployed API server
- Consider adding rate limiting on authentication endpoints
- Add input validation and sanitization on all API endpoints

## Development

- **Database Migrations**: Use `npm run db:push` to sync schema changes
- **Server Auto-Reload**: Install `nodemon` for development: `npm install -g nodemon && nodemon server.js`

## Scripts

- `npm start` - Start the server
- `npm run db:push` - Push database schema changes

## License

ISC

## Credits

Created by Yopicky Team
